/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import com.mojang.authlib.GameProfile;
import dan200.computercraft.api.lua.ILuaCallback;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommand;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.core.util.PeripheralHelpers;
import dan200.computercraft.impl.TurtleUpgrades;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.config.Config;
import dan200.computercraft.shared.turtle.TurtleOverlay;
import dan200.computercraft.shared.turtle.blocks.TurtleBlockEntity;
import dan200.computercraft.shared.turtle.core.TurtleAccessInternal;
import dan200.computercraft.shared.turtle.core.TurtleCommandQueueEntry;
import dan200.computercraft.shared.turtle.core.TurtlePlayer;
import dan200.computercraft.shared.util.BlockEntityHelpers;
import dan200.computercraft.shared.util.Holiday;
import dan200.computercraft.shared.util.NBTUtil;
import dan200.computercraft.shared.util.WaterloggableHelpers;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1313;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3619;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_9326;
import org.jspecify.annotations.Nullable;

public class TurtleBrain
implements TurtleAccessInternal {
    public static final String NBT_FUEL = "Fuel";
    public static final String NBT_OVERLAY = "Overlay";
    public static final String NBT_COLOUR = "Color";
    public static final String NBT_LEFT_UPGRADE = "LeftUpgrade";
    public static final String NBT_RIGHT_UPGRADE = "RightUpgrade";
    private static final String NBT_SLOT = "Slot";
    private static final int ANIM_DURATION = 8;
    private TurtleBlockEntity owner;
    private @Nullable GameProfile owningPlayer;
    private final class_1263 inventory = () -> this.owner;
    private final Queue<TurtleCommandQueueEntry> commandQueue = new ArrayDeque<TurtleCommandQueueEntry>();
    private int commandsIssued = 0;
    private final UpgradeInstance[] upgrades = new UpgradeInstance[]{new UpgradeInstance(), new UpgradeInstance()};
    private int selectedSlot = 0;
    private int fuelLevel = 0;
    private int colourHex = -1;
    private @Nullable class_6880<TurtleOverlay> overlay = null;
    private TurtleAnimation animation = TurtleAnimation.NONE;
    private int animationProgress = 0;
    private int lastAnimationProgress = 0;
    @Nullable TurtlePlayer cachedPlayer;

    public TurtleBrain(TurtleBlockEntity turtle) {
        this.owner = turtle;
    }

    public void setOwner(TurtleBlockEntity owner) {
        this.owner = owner;
    }

    public TurtleBlockEntity getOwner() {
        return this.owner;
    }

    public ComputerFamily getFamily() {
        return this.owner.getFamily();
    }

    public void setupComputer(ServerComputer computer) {
        this.updatePeripherals(computer);
    }

    public void update() {
        class_1937 world = this.getLevel();
        if (!world.field_9236) {
            this.updateCommands();
            if (this.owner.method_11015()) {
                return;
            }
        }
        this.updateAnimation();
        for (TurtleSide side : TurtleSide.values()) {
            class_6880.class_6883<ITurtleUpgrade> upgrade = this.upgrades[side.ordinal()].upgrade;
            if (upgrade == null) continue;
            ((ITurtleUpgrade)upgrade.comp_349()).update(this, side);
        }
    }

    private void readCommon(class_2487 nbt, class_7225.class_7874 registries) {
        this.colourHex = nbt.method_10545(NBT_COLOUR) ? nbt.method_10550(NBT_COLOUR) : -1;
        this.fuelLevel = nbt.method_10545(NBT_FUEL) ? nbt.method_10550(NBT_FUEL) : 0;
        this.overlay = nbt.method_10545(NBT_OVERLAY) ? NBTUtil.decodeFrom(TurtleOverlay.CODEC, registries, nbt, NBT_OVERLAY) : null;
        this.setUpgradeDirect(TurtleSide.LEFT, NBTUtil.decodeFrom(TurtleUpgrades.instance().upgradeDataCodec(), registries, nbt, NBT_LEFT_UPGRADE));
        this.setUpgradeDirect(TurtleSide.RIGHT, NBTUtil.decodeFrom(TurtleUpgrades.instance().upgradeDataCodec(), registries, nbt, NBT_RIGHT_UPGRADE));
    }

    private void writeCommon(class_2487 nbt, class_7225.class_7874 registries) {
        nbt.method_10569(NBT_FUEL, this.fuelLevel);
        if (this.colourHex != -1) {
            nbt.method_10569(NBT_COLOUR, this.colourHex);
        }
        if (this.overlay != null) {
            NBTUtil.encodeTo(TurtleOverlay.CODEC, registries, nbt, NBT_OVERLAY, this.overlay);
        }
        NBTUtil.encodeTo(TurtleUpgrades.instance().upgradeDataCodec(), registries, nbt, NBT_LEFT_UPGRADE, this.getUpgradeWithData(TurtleSide.LEFT));
        NBTUtil.encodeTo(TurtleUpgrades.instance().upgradeDataCodec(), registries, nbt, NBT_RIGHT_UPGRADE, this.getUpgradeWithData(TurtleSide.RIGHT));
    }

    public void readFromNBT(class_2487 nbt, class_7225.class_7874 registries) {
        this.readCommon(nbt, registries);
        this.selectedSlot = nbt.method_10550(NBT_SLOT);
        if (nbt.method_10573("Owner", 10)) {
            class_2487 owner = nbt.method_10562("Owner");
            this.owningPlayer = new GameProfile(new UUID(owner.method_10537("UpperId"), owner.method_10537("LowerId")), owner.method_10558("Name"));
        } else {
            this.owningPlayer = null;
        }
    }

    public void writeToNBT(class_2487 nbt, class_7225.class_7874 registries) {
        this.writeCommon(nbt, registries);
        nbt.method_10569(NBT_SLOT, this.selectedSlot);
        if (this.owningPlayer != null) {
            class_2487 owner = new class_2487();
            nbt.method_10566("Owner", (class_2520)owner);
            owner.method_10544("UpperId", this.owningPlayer.getId().getMostSignificantBits());
            owner.method_10544("LowerId", this.owningPlayer.getId().getLeastSignificantBits());
            owner.method_10582("Name", this.owningPlayer.getName());
        }
    }

    public void readDescription(class_2487 nbt, class_7225.class_7874 registries) {
        this.readCommon(nbt, registries);
        TurtleAnimation anim = TurtleAnimation.values()[nbt.method_10550("Animation")];
        if (anim != this.animation && anim != TurtleAnimation.WAIT && anim != TurtleAnimation.SHORT_WAIT && anim != TurtleAnimation.NONE) {
            this.animation = anim;
            this.animationProgress = 0;
            this.lastAnimationProgress = 0;
        }
    }

    public void writeDescription(class_2487 nbt, class_7225.class_7874 registries) {
        this.writeCommon(nbt, registries);
        nbt.method_10569("Animation", this.animation.ordinal());
    }

    @Override
    public class_1937 getLevel() {
        return this.owner.method_10997();
    }

    @Override
    public class_2338 getPosition() {
        return this.owner.method_11016();
    }

    @Override
    public boolean isRemoved() {
        return this.owner.method_11015();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean teleportTo(class_1937 world, class_2338 pos) {
        if (world.field_9236 || this.getLevel().field_9236) {
            throw new UnsupportedOperationException("Cannot teleport on the client");
        }
        class_1937 oldWorld = this.getLevel();
        TurtleBlockEntity oldOwner = this.owner;
        class_2338 oldPos = this.owner.method_11016();
        class_2680 oldBlock = this.owner.method_11010();
        if (oldWorld == world && oldPos.equals((Object)pos)) {
            return true;
        }
        if (!world.method_8477(pos)) {
            return false;
        }
        if (!world.method_8621().method_11952(pos)) {
            return false;
        }
        class_3610 existingFluid = world.method_8320(pos).method_26227();
        class_2680 newState = (class_2680)oldBlock.method_11657((class_2769)WaterloggableHelpers.WATERLOGGED, (Comparable)Boolean.valueOf(existingFluid.method_15767(class_3486.field_15517) && existingFluid.method_15771()));
        oldOwner.notifyMoveStart();
        try {
            if (world.method_8652(pos, newState, 2)) {
                class_2586 newTile;
                class_2248 block = world.method_8320(pos).method_26204();
                if (block == oldBlock.method_26204() && (newTile = world.method_8321(pos)) instanceof TurtleBlockEntity) {
                    TurtleBlockEntity newTurtle = (TurtleBlockEntity)newTile;
                    newTurtle.method_31662(world);
                    newTurtle.transferStateFrom(oldOwner);
                    ServerComputer computer = newTurtle.createServerComputer();
                    computer.setPosition((class_3218)world, pos);
                    oldWorld.method_8650(oldPos, false);
                    newTurtle.updateRedstone();
                    newTurtle.updateInputsImmediately();
                    boolean bl = true;
                    return bl;
                }
                world.method_8650(pos, false);
            }
        }
        finally {
            oldOwner.notifyMoveEnd();
        }
        return false;
    }

    public class_243 getVisualPosition(float f) {
        class_243 offset = this.getRenderOffset(f);
        class_2338 pos = this.owner.method_11016();
        return new class_243((double)pos.method_10263() + 0.5 + offset.field_1352, (double)pos.method_10264() + 0.5 + offset.field_1351, (double)pos.method_10260() + 0.5 + offset.field_1350);
    }

    public float getVisualYaw(float f) {
        float yaw = this.getDirection().method_10144();
        switch (this.animation) {
            case TURN_LEFT: {
                yaw += 90.0f * (1.0f - this.getAnimationFraction(f));
                if (!(yaw >= 360.0f)) break;
                yaw -= 360.0f;
                break;
            }
            case TURN_RIGHT: {
                yaw += -90.0f * (1.0f - this.getAnimationFraction(f));
                if (!(yaw < 0.0f)) break;
                yaw += 360.0f;
                break;
            }
        }
        return yaw;
    }

    @Override
    public class_2350 getDirection() {
        return this.owner.getDirection();
    }

    @Override
    public void setDirection(class_2350 dir) {
        this.owner.setDirection(dir);
    }

    @Override
    public int getSelectedSlot() {
        return this.selectedSlot;
    }

    @Override
    public void setSelectedSlot(int slot) {
        if (this.getLevel().field_9236) {
            throw new UnsupportedOperationException("Cannot set the slot on the client");
        }
        if (slot >= 0 && slot < this.owner.method_5439()) {
            this.selectedSlot = slot;
            this.owner.onTileEntityChange();
        }
    }

    @Override
    public class_1263 getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isFuelNeeded() {
        return Config.turtlesNeedFuel;
    }

    @Override
    public int getFuelLevel() {
        return Math.min(this.fuelLevel, this.getFuelLimit());
    }

    @Override
    public void setFuelLevel(int level) {
        this.fuelLevel = Math.min(level, this.getFuelLimit());
        this.owner.onTileEntityChange();
    }

    @Override
    public int getFuelLimit() {
        return this.owner.getFuelLimit();
    }

    @Override
    public boolean consumeFuel(int fuel) {
        if (this.getLevel().field_9236) {
            throw new UnsupportedOperationException("Cannot consume fuel on the client");
        }
        if (!this.isFuelNeeded()) {
            return true;
        }
        int consumption = Math.max(fuel, 0);
        if (this.getFuelLevel() >= consumption) {
            this.setFuelLevel(this.getFuelLevel() - consumption);
            return true;
        }
        return false;
    }

    @Override
    public void addFuel(int fuel) {
        if (this.getLevel().field_9236) {
            throw new UnsupportedOperationException("Cannot add fuel on the client");
        }
        int addition = Math.max(fuel, 0);
        this.setFuelLevel(this.getFuelLevel() + addition);
    }

    @Override
    public MethodResult executeCommand(TurtleCommand command) {
        if (this.getLevel().field_9236) {
            throw new UnsupportedOperationException("Cannot run commands on the client");
        }
        if (this.commandQueue.size() > 16) {
            return MethodResult.of(false, "Too many ongoing turtle commands");
        }
        this.commandQueue.offer(new TurtleCommandQueueEntry(++this.commandsIssued, command));
        int commandID = this.commandsIssued;
        return new CommandCallback((int)commandID).pull;
    }

    @Override
    public void playAnimation(TurtleAnimation animation) {
        if (this.getLevel().field_9236) {
            throw new UnsupportedOperationException("Cannot play animations on the client");
        }
        this.animation = animation;
        if (this.animation == TurtleAnimation.SHORT_WAIT) {
            this.animationProgress = 4;
            this.lastAnimationProgress = 4;
        } else {
            this.animationProgress = 0;
            this.lastAnimationProgress = 0;
        }
        BlockEntityHelpers.updateBlock(this.owner);
    }

    public @Nullable class_6880<TurtleOverlay> getOverlay() {
        return this.overlay;
    }

    public void setOverlay(@Nullable class_6880<TurtleOverlay> overlay) {
        if (!Objects.equals(this.overlay, overlay)) {
            this.overlay = overlay;
            BlockEntityHelpers.updateBlock(this.owner);
        }
    }

    @Override
    public void setColour(int colour) {
        if (colour >= 0 && colour <= 0xFFFFFF) {
            if (this.colourHex != colour) {
                this.colourHex = colour;
                BlockEntityHelpers.updateBlock(this.owner);
            }
        } else if (this.colourHex != -1) {
            this.colourHex = -1;
            BlockEntityHelpers.updateBlock(this.owner);
        }
    }

    @Override
    public int getColour() {
        return this.colourHex;
    }

    public void setOwningPlayer(GameProfile profile) {
        this.owningPlayer = profile;
    }

    @Override
    public @Nullable GameProfile getOwningPlayer() {
        return this.owningPlayer;
    }

    @Override
    public @Nullable ITurtleUpgrade getUpgrade(TurtleSide side) {
        class_6880.class_6883<ITurtleUpgrade> upgrade = this.upgrades[side.ordinal()].upgrade;
        return upgrade == null ? null : (ITurtleUpgrade)upgrade.comp_349();
    }

    @Override
    public @Nullable UpgradeData<ITurtleUpgrade> getUpgradeWithData(TurtleSide side) {
        return this.upgrades[side.ordinal()].getUpgrade();
    }

    @Override
    public void setUpgrade(TurtleSide side, @Nullable UpgradeData<ITurtleUpgrade> upgrade) {
        if (!this.setUpgradeDirect(side, upgrade) || this.owner.method_10997() == null) {
            return;
        }
        BlockEntityHelpers.updateBlock(this.owner);
        this.owner.updateInputsImmediately();
    }

    private boolean setUpgradeDirect(TurtleSide side, @Nullable UpgradeData<ITurtleUpgrade> upgrade) {
        UpgradeInstance instance = this.upgrades[side.ordinal()];
        if (instance.upgrade == null && upgrade == null) {
            return false;
        }
        instance.setUpgrade(upgrade);
        if (this.owner.method_10997() != null && !this.owner.method_10997().field_9236) {
            this.updatePeripherals(this.owner.createServerComputer());
        }
        return true;
    }

    @Override
    public @Nullable IPeripheral getPeripheral(TurtleSide side) {
        return this.upgrades[side.ordinal()].peripheral;
    }

    @Override
    public class_9326 getUpgradeData(TurtleSide side) {
        return this.upgrades[side.ordinal()].data;
    }

    @Override
    public void setUpgradeData(TurtleSide side, class_9326 data) {
        UpgradeInstance upgrade = this.upgrades[side.ordinal()];
        if (Objects.equals(upgrade.data, data)) {
            return;
        }
        upgrade.data = data;
        upgrade.cachedUpgradeData = null;
        BlockEntityHelpers.updateBlock(this.owner);
    }

    public class_243 getRenderOffset(float f) {
        switch (this.animation) {
            case MOVE_FORWARD: 
            case MOVE_BACK: 
            case MOVE_UP: 
            case MOVE_DOWN: {
                class_2350 dir = switch (this.animation) {
                    case TurtleAnimation.MOVE_FORWARD -> this.getDirection();
                    case TurtleAnimation.MOVE_BACK -> this.getDirection().method_10153();
                    case TurtleAnimation.MOVE_UP -> class_2350.field_11036;
                    case TurtleAnimation.MOVE_DOWN -> class_2350.field_11033;
                    default -> throw new IllegalStateException("Impossible direction");
                };
                double distance = -1.0 + (double)this.getAnimationFraction(f);
                return new class_243(distance * (double)dir.method_10148(), distance * (double)dir.method_10164(), distance * (double)dir.method_10165());
            }
        }
        return class_243.field_1353;
    }

    public float getToolRenderAngle(TurtleSide side, float f) {
        return side == TurtleSide.LEFT && this.animation == TurtleAnimation.SWING_LEFT_TOOL || side == TurtleSide.RIGHT && this.animation == TurtleAnimation.SWING_RIGHT_TOOL ? 45.0f * (float)Math.sin((double)this.getAnimationFraction(f) * Math.PI) : 0.0f;
    }

    private static ComputerSide toDirection(TurtleSide side) {
        return switch (side) {
            default -> throw new MatchException(null, null);
            case TurtleSide.LEFT -> ComputerSide.LEFT;
            case TurtleSide.RIGHT -> ComputerSide.RIGHT;
        };
    }

    private void updatePeripherals(ServerComputer serverComputer) {
        if (serverComputer == null) {
            return;
        }
        for (TurtleSide side : TurtleSide.values()) {
            ITurtleUpgrade upgrade = this.getUpgrade(side);
            IPeripheral peripheral = null;
            if (upgrade != null && upgrade.getUpgradeType().isPeripheral()) {
                peripheral = upgrade.createPeripheral(this, side);
            }
            UpgradeInstance instance = this.upgrades[side.ordinal()];
            if (PeripheralHelpers.equals(instance.peripheral, peripheral)) {
                peripheral = instance.peripheral;
            } else {
                instance.peripheral = peripheral;
            }
            serverComputer.setPeripheral(TurtleBrain.toDirection(side), peripheral);
        }
    }

    private void updateCommands() {
        if (this.animation != TurtleAnimation.NONE || this.commandQueue.isEmpty()) {
            return;
        }
        ServerComputer computer = this.owner.getServerComputer();
        if (computer != null && !computer.getMainThreadMonitor().canWork()) {
            return;
        }
        TurtleCommandQueueEntry nextCommand = this.commandQueue.poll();
        if (nextCommand == null) {
            return;
        }
        long start = System.nanoTime();
        TurtleCommandResult result = nextCommand.command().execute(this);
        long end = System.nanoTime();
        if (computer == null) {
            return;
        }
        computer.getMainThreadMonitor().trackWork(end - start, TimeUnit.NANOSECONDS);
        int callbackID = nextCommand.callbackID();
        if (callbackID < 0) {
            return;
        }
        if (result != null && result.isSuccess()) {
            Object[] results = result.getResults();
            if (results != null) {
                Object[] arguments = new Object[results.length + 2];
                arguments[0] = callbackID;
                arguments[1] = true;
                System.arraycopy(results, 0, arguments, 2, results.length);
                computer.queueEvent("turtle_response", arguments);
            } else {
                computer.queueEvent("turtle_response", new Object[]{callbackID, true});
            }
        } else {
            computer.queueEvent("turtle_response", new Object[]{callbackID, false, result != null ? result.getErrorMessage() : null});
        }
    }

    private void updateAnimation() {
        if (this.animation != TurtleAnimation.NONE) {
            class_243 position;
            Holiday currentHoliday;
            class_1937 world = this.getLevel();
            if (Config.turtlesCanPush && (this.animation == TurtleAnimation.MOVE_FORWARD || this.animation == TurtleAnimation.MOVE_BACK || this.animation == TurtleAnimation.MOVE_UP || this.animation == TurtleAnimation.MOVE_DOWN)) {
                class_2338 pos = this.getPosition();
                class_2350 moveDir = switch (this.animation) {
                    case TurtleAnimation.MOVE_FORWARD -> this.getDirection();
                    case TurtleAnimation.MOVE_BACK -> this.getDirection().method_10153();
                    case TurtleAnimation.MOVE_UP -> class_2350.field_11036;
                    case TurtleAnimation.MOVE_DOWN -> class_2350.field_11033;
                    default -> throw new IllegalStateException("Impossible direction");
                };
                double minX = pos.method_10263();
                double minY = pos.method_10264();
                double minZ = pos.method_10260();
                double maxX = minX + 1.0;
                double maxY = minY + 1.0;
                double maxZ = minZ + 1.0;
                float pushFrac = 1.0f - (float)(this.animationProgress + 1) / 8.0f;
                float push = Math.max(pushFrac + 0.0125f, 0.0f);
                if (moveDir.method_10148() < 0) {
                    minX += (double)((float)moveDir.method_10148() * push);
                } else {
                    maxX -= (double)((float)moveDir.method_10148() * push);
                }
                if (moveDir.method_10164() < 0) {
                    minY += (double)((float)moveDir.method_10164() * push);
                } else {
                    maxY -= (double)((float)moveDir.method_10164() * push);
                }
                if (moveDir.method_10165() < 0) {
                    minZ += (double)((float)moveDir.method_10165() * push);
                } else {
                    maxZ -= (double)((float)moveDir.method_10165() * push);
                }
                class_238 aabb = new class_238(minX, minY, minZ, maxX, maxY, maxZ);
                List list = world.method_8333((class_1297)null, aabb, TurtleBrain::canPush);
                if (!list.isEmpty()) {
                    double pushStep = 0.125;
                    double pushStepX = (double)moveDir.method_10148() * pushStep;
                    double pushStepY = (double)moveDir.method_10164() * pushStep;
                    double pushStepZ = (double)moveDir.method_10165() * pushStep;
                    for (class_1297 entity : list) {
                        entity.method_5784(class_1313.field_6310, new class_243(pushStepX, pushStepY, pushStepZ));
                    }
                }
            }
            if (world.field_9236 && this.animation == TurtleAnimation.MOVE_FORWARD && this.animationProgress == 4 && (currentHoliday = Holiday.getCurrent()) == Holiday.VALENTINES && (position = this.getVisualPosition(1.0f)) != null) {
                double x = position.field_1352 + world.field_9229.method_43059() * 0.1;
                double y = position.field_1351 + 0.5 + world.field_9229.method_43059() * 0.1;
                double z = position.field_1350 + world.field_9229.method_43059() * 0.1;
                world.method_8406((class_2394)class_2398.field_11201, x, y, z, world.field_9229.method_43059() * 0.02, world.field_9229.method_43059() * 0.02, world.field_9229.method_43059() * 0.02);
            }
            this.lastAnimationProgress = this.animationProgress++;
            if (this.animationProgress >= 8) {
                this.animation = TurtleAnimation.NONE;
                this.animationProgress = 0;
                this.lastAnimationProgress = 0;
            }
        }
    }

    private static boolean canPush(class_1297 entity) {
        return !entity.method_7325() && entity.method_5657() != class_3619.field_15975;
    }

    private float getAnimationFraction(float f) {
        float next = (float)this.animationProgress / 8.0f;
        float previous = (float)this.lastAnimationProgress / 8.0f;
        return previous + (next - previous) * f;
    }

    @Override
    public class_1799 getItemSnapshot(int slot) {
        return this.owner.getItemSnapshot(slot);
    }

    private static final class UpgradeInstance {
        private // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable class_6880.class_6883<ITurtleUpgrade> upgrade;
        private class_9326 data = class_9326.field_49588;
        private @Nullable IPeripheral peripheral;
        private @Nullable UpgradeData<ITurtleUpgrade> cachedUpgradeData;

        private UpgradeInstance() {
        }

        public void setUpgrade(@Nullable UpgradeData<ITurtleUpgrade> upgrade) {
            if (upgrade == null) {
                this.upgrade = null;
                this.data = class_9326.field_49588;
                this.cachedUpgradeData = null;
            } else {
                this.upgrade = upgrade.holder();
                this.data = upgrade.data();
                this.cachedUpgradeData = upgrade;
            }
        }

        public @Nullable UpgradeData<ITurtleUpgrade> getUpgrade() {
            if (this.upgrade == null) {
                return null;
            }
            UpgradeData<ITurtleUpgrade> cached = this.cachedUpgradeData;
            if (cached != null) {
                return cached;
            }
            this.cachedUpgradeData = UpgradeData.of(this.upgrade, this.data);
            return this.cachedUpgradeData;
        }
    }

    private static final class CommandCallback
    implements ILuaCallback {
        final MethodResult pull = MethodResult.pullEvent("turtle_response", this);
        private final int command;

        CommandCallback(int command) {
            this.command = command;
        }

        @Override
        public MethodResult resume(Object[] response) {
            Number id;
            block5: {
                block4: {
                    Object object;
                    if (response.length < 3 || !((object = response[1]) instanceof Number)) break block4;
                    id = (Number)object;
                    if (response[2] instanceof Boolean) break block5;
                }
                return this.pull;
            }
            if (id.intValue() != this.command) {
                return this.pull;
            }
            return MethodResult.of(Arrays.copyOfRange(response, 2, response.length));
        }
    }
}

